/*
    -----------------------------------------------------------------------------

                   --- CAEN SpA - Computing Systems Division ---

    -----------------------------------------------------------------------------

    CAENRFIDLib.h

    -----------------------------------------------------------------------------
	Author: Andrea Iavazzo (support@caenrfid.com)  CAEN RFID srl 

	Created: May 2023

    -----------------------------------------------------------------------------
*/

#define deprecate_msg(message) __declspec(deprecated(message))  

#ifndef __CAENRFIDLIB_H
#define __CAENRFIDLIB_H
//#define byte unsigned char  ORA

#include "CAENRFIDoslib.h"
#include "CAENRFIDTypes.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/*
        CAENRFID_Init
        -----------------------------------------------------------------------------
        Parameters:
            [in]  Port      : Communication port (see CAENRFIDPort enum).
            [in]  Address   : Communication address (i.e.: "COM1" for RS232,
                              "USB0" for USB of IP address for TCP/IP etc.)
			[in]  Protocol  : 
            [out] Handle    : The handle that identifies the device.
        -----------------------------------------------------------------------------
        Returns:
            An error code about the execution of the function.
        -----------------------------------------------------------------------------
        Description:
            The function generates an opaque handle to identify a module
            attached to the PC.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Init (CAENRFIDPort Port, const char *Address, CAENRFIDHandle *Handle, CAENRFIDProtocol *Protocol);

/*
    CAENRFID_End
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Notifies the library the end of work and free the allocated
        resources.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_End(CAENRFIDHandle Handle);

/*
    CAENRFID_GetSWRelease
    -----------------------------------------------------------------------------
    Parameters:
        [out] SwRel : Returns the software release of the library.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Permits to read the software release of the library.
*/
CAENRFIDlib_API  deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetSWRelease(char *SwRel);

/*
    CAENRFID_GetFWRelease.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [out] FWRel : Returns the firmware release of the device.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Permits to read the firmware release loaded into the device.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetFWRelease(CAENRFIDHandle Handle, char *FWRel);

/*
    CAENRFID_GetFirmwareRelease.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [out] FWRel : Returns the firmware release of the device.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Permits to read the firmware release loaded into the device.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetFirmwareRelease(CAENRFIDHandle Handle, char *FWRel);

/*
    CAENRFID_GetFirmwareReleaseLevel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle : The handle that identifies the device.
        [in]  Level  : It's a number that specifies the level of internal rfid module
                       module embedded inside the reader from which getting info. 
        [out] FWRel  : Returns the firmware release of the device.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Permits to read the firmware release loaded into the devicer, or one of it's
        internal module. Typical value is limited to 1. Call this function with Level = 0,
        it's equivalent to call CAENRFID_GetFirmwareRelease(CAENRFIDHandle, char*).
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetFirmwareReleaseLevel(CAENRFIDHandle Handle, short level, char* FWRel);


/*
    CAENRFID_Inventory.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  LogicalSourceName : The name that identify the Logical Source
        [out] Tags  : Returns an array containing the tags read.
        [out] TagsNo    : Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_Inventory(CAENRFIDHandle Handle, char *LogicalSourceName, CAENRFIDTag **Tags, int *TagsNo);

/*
    CAENRFID_SetPower.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
                [in]  Power     : RF field power expressed in mW.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the RF field power relative to the antenna
        socket.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetPower(CAENRFIDHandle Handle, unsigned int Power);

/*
    CAENRFID_SetReadPointPower.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  Antenna   : The antenna name where to set power.
        [in]  Power     : RF field power expressed in mW.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the RF field power relative to a specific antenna
        socket.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetReadPointPower(CAENRFIDHandle Handle, char* Antenna, unsigned int Power);


/*
    CAENRFID_Read (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the memory to read.
        [in]  Length    : The number of bytes to read.
        [out] Data      : The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to read Length bytes from the memory of a
        specific tag identified by the ID (regardless of its status) at the
        address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer supported.Use ReadTagData instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_Read(CAENRFIDHandle Handle, CAENRFIDTag *ID, int Address, int Length, void *Data);

/*
    CAENRFID_ReadTagData
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag.
        [in]  Address   : The address of the memory to read.
        [in]  Length    : The number of bytes to read.
        [out] Data      : The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to read Length bytes from the memory of a
        specific tag identified by the ID (regardless of its status) at the
        address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ReadTagData(CAENRFIDHandle Handle, CAENRFIDTag *ID, int Address, int Length, void *Data);

/*
    CAENRFID_Write (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the memory to write.
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the memory of a
        specific tag identified by the ID (regardless of its status) at the
        address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer supported.Use WriteTagData instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_Write(CAENRFIDHandle Handle, CAENRFIDTag *ID, int Address, int Length, void *Data);

/*
    CAENRFID_Write (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  Tag        : The tag ID.
        [in]  Address   : The address of the memory to write.
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the memory of a
        specific tag identified by the ID (regardless of its status) at the
        address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_WriteTagData(CAENRFIDHandle Handle, CAENRFIDTag *Tag, int Address, int Length, void *Data);


/*
    CAENRFID_Lock (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to lockthe memory of a
        specific tag identified by the ID at the address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer supported.Use LockTag_ISO18006B instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_Lock(CAENRFIDHandle Handle, CAENRFIDTag *ID, short Address);

/*
    CAENRFID_Lock (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to lockthe memory of a
        specific tag identified by the ID at the address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_LockTag_ISO180006B(CAENRFIDHandle Handle, CAENRFIDTag *ID, short Address);


/*
    CAENRFID_SetModulation. (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  TxRxCfg   : Modulation setting.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to control to choose the modulation (the bit
        rate of the transmission and receive).
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.Use CAENRFID_SetBitRate instead.") CAENRFIDErrorCodes  __stdcall
CAENRFID_SetModulation(CAENRFIDHandle Handle, unsigned short TxRxCfg);
/*
    CAENRFID_SetBitrate.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  br   : Modulation setting.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to control to choose the modulation (the bit
        rate of the transmission and receive).
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SetBitRate instead.")CAENRFIDErrorCodes  __stdcall 
CAENRFID_SetBitrate(CAENRFIDHandle handle, CAENRFID_Bitrate br);

/*
    CAENRFID_SetBitRate.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  BitRate		: link-profile setting.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to control to choose the modulation (the bit
        rate of the transmission and receive).
*/
CAENRFIDlib_API CAENRFIDErrorCodes  __stdcall 
CAENRFID_SetBitRate(CAENRFIDHandle handle, CAENRFID_Bitrate Bitrate);

/*
    CAENRFID_GetModulation.(DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [out]  TxRxCfg  : Modulation setting.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to retrieve the modulation (the bit
        rate of the transmission and receive).
*/
CAENRFIDlib_API deprecate_msg("Deprecated Function.Use CAENRFID_GetBitRate instead.") CAENRFIDErrorCodes  __stdcall
CAENRFID_GetModulation(CAENRFIDHandle handle, unsigned short *TxRx);

/*
    CAENRFID_GetBitrate.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [out]  Bitrate  : Modulation setting.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to retrieve the modulation (the bit
        rate of the transmission and receive).
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use GetBitRate instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetBitrate(CAENRFIDHandle handle, CAENRFID_Bitrate *Bitrate);

/*
    CAENRFID_GetBitRate.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [out]  Bitrate  : Modulation setting.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to retrieve the modulation (the bit
        rate of the transmission and receive).
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetBitRate(CAENRFIDHandle handle, CAENRFID_Bitrate *Bitrate);

/*
    CAENRFID_PrintScreen
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  Text  : An arbitrary ASCII string.
		[in]  TerminalType	: RFU parameter, default is 0 (VT100).
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Print ASCII text on the reader's screen (if available).
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_PrintScreen(CAENRFIDHandle handle, char * Text, unsigned short TerminalType);


/*
    CAENRFID_AllocateChannel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ChannelName    : The Name of the Channel.
        [in]  ChannelAddress : The Address of the Channel.
                                in the form [TCP|USB|RS232]://[ip address:port]
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to allocate a notification Channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_AllocateChannel(CAENRFIDHandle handle, char *ChannelName, char *ChannelAddress);

/*
    CAENRFID_DeallocateChannel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ChannelName    : The Name of the Channel.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to Deallocate a Channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_DeallocateChannel(CAENRFIDHandle handle, char *ChannelName);

/*
    CAENRFID_AddSourceToChannel (DEPRECATED).
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The Name of the Logical Source.
        [in]  ChannelName    : The Address of the Channel.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to add a LogicalSource to a notification Channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_AddSourceToChannel(CAENRFIDHandle handle, char* SourceName, char *ChannelName);

/*
    CAENRFID_RemoveSourceFromChannel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The Name of the Logical Source.
        [in]  ChannelName    : The Address of the Channel.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to remove a LogicalSource from a notification Channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_RemoveSourceFromChannel(CAENRFIDHandle handle, char* SourceName, char *ChannelName);

/*
    CAENRFID_AddReadPoint.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  ReadPoint      : The name of the Read Point.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to add a read point (antenna) to a logical source..
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_AddReadPoint(CAENRFIDHandle handle, char* SourceName, char* ReadPoint);

/*
    CAENRFID_RemoveReadPoint.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  ReadPoint      : The name of the Read Point.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to add a read point (antenna) to a logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_RemoveReadPoint(CAENRFIDHandle handle, char* SourceName, char* ReadPoint);

/*
    CAENRFID_AllocateTrigger.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TriggerName    : The name of the trigger.
        [in]  TriggerType    : The type of the trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to create a trigger of the specified type.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_AllocateTrigger(CAENRFIDHandle handle, char *TriggerName, char *TriggerType);

/*
    CAENRFID_DeallocateTrigger.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TriggerName    : The name of the trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to destroy a trigger.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_DeallocateTrigger(CAENRFIDHandle handle, char *TriggerName);

/*
    CAENRFID_AddReadTrigger (DEPRECATED).
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  TriggerName    : The name of the trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to associate a trigger to a source in order to
        start a read cycle.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_AddReadTrigger(CAENRFIDHandle handle, char* SourceName, char *TriggerName);

/*
    CAENRFID_RemoveReadTrigger.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  TriggerName    : The name of the trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to remove the read trigger from the logical source.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_RemoveReadTrigger(CAENRFIDHandle handle, char* SourceName, char *TriggerName);

/*
    CAENRFID_AddNotifyTrigger (DEPRECATED).
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ChannelName    : The Address of the Channel.
        [in]  TriggerName    : The name of the trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to associate a trigger to a channel in order to
        start a notification.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_AddNotifyTrigger(CAENRFIDHandle handle, char *ChannelName, char *TriggerName);

/*
    CAENRFID_RemoveNotifyTrigger.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ChannelName    : The Address of the Channel.
        [in]  TriggerName    : The name of the trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to remove the notification trigger from a channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_RemoveNotifyTrigger(CAENRFIDHandle handle, char *ChannelName, char *TriggerName);

/*
    CAENRFID_GetNotification.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Skt            : The handle to the TCP socket.
        [out] Items          : A list of data items.
        [out] NoItems        : The number of data items in the list..
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to decode data coming from the notification channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetNotification(SOCKET Skt, CAENRFIDNotify **Items, int *NumberItems);

/*
    CAENRFID_GetPower.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] Power          : The conducted power of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns the value of the conducted power setting in the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetPower(CAENRFIDHandle Handle, unsigned int *Power);


/*
    CAENRFID_GetReadPointPower.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  Antenna        : The antenna name where to get power level.
        [out] Power          : The conducted power of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns the value of the conducted power setting in the reader
        for a specified antenna socket.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetReadPointPower(CAENRFIDHandle Handle, char* Antenna, unsigned int* Power);


/*
    CAENRFID_GetBatteryLevel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] Charge         : The percentage of battery's charge level.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function calculates the battery level of the reader expressed in %.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetBatteryLevel(CAENRFIDHandle Handle, unsigned int *Charge);

/*
    CAENRFID_SetProtocol.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  Protocol       : The tag protocol to be set in the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to change the tag protocol used by the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetProtocol (CAENRFIDHandle Handle, CAENRFIDProtocol Protocol);

/*
    CAENRFID_GetProtocol.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] Protocol       : The tag protocol to be set in the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to know what tag protocol is used by the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetProtocol(CAENRFIDHandle Handle, int *Protocol);


  /// <summary>
        ///  MatchReadPointImpedance matches the antenna impedance passed in <para>ReadPoint</para>.
        /// </summary>
        /// <param name="ReadPoint">The antenna to be matched</param>
        /// <param name="MatchParam">A CAENRFIDMatchingParams parameters for matching operation.</param>
        /// <param name="MatchParamValue">The value of the <para>MatchParam</para>.</param>
        /// <returns>A real number greater then one,that rapresent the return status of the matching operation</returns>

/*
    CAENRFID_MatchReadPointImpedance.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle      : The handle that identifies the device.
		[in]  ReadPoint   : The antenna to be matched.
        [out] Value       : A real number greater then one,that rapresent the return status of the matching operation
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        MatchReadPointImpedance matches the antenna impedance passed in.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_MatchReadPointImpedance(CAENRFIDHandle handle, char* ReadPoint, float* Value) ;


/*
    CAENRFID_ParametrizedMatchReadPointImpedance.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle          : The handle that identifies the device.
		[in]  ReadPoint       : The antenna to be matched.
		[in]  MatchParam      : A CAENRFIDMatchingParams parameters for matching operation.
		[in]  MatchParamValue : The value of the aram</para>.
        [out] Value           : A real number greater then one,that rapresent the return status of the matching operation
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        CAENRFID_ParametrizedMatchReadPointImpedance matches the antenna impedance passed in.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ParametrizedMatchReadPointImpedance(CAENRFIDHandle handle, char* ReadPoint, CAENRFIDMatchingParams MatchParam, int MatchParamValue, float* Value);




/*
    CAENRFID_GetReadPointStatus.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ReadPoint      : The name of the Read Point.
        [out] Status         : The status of the read point.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check the status of a read point.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetReadPointStatus(CAENRFIDHandle Handle, char* ReadPoint, CAENRFIDReadPointStatus *Status);

/*
    CAENRFID_MatchReadPointImpedance.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[in]  ReadPoint		 : The name of the ReadPoint to apply impedance automatching.
		[out] Status		 : The status of the automatching.
    -----------------------------------------------------------------------------
    Returns:
        A real number greater then one,that rapresent the return status of the matching operation
    -----------------------------------------------------------------------------
    Description:
		The function matches the antenna impedance passed in ReadPoint parameter.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_MatchReadPointImpedance(CAENRFIDHandle Handle, char* ReadPoint, float *Status);

/*
    CAENRFID_FlagMatchReadPointImpedance.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[in]  ReadPoint		 : The name of the ReadPoint to apply impedance automatching.
		[in]  Flag           : A CAENRFIDMatchingParams parameters for matching operation.
		[out] Status		 : The status of the automatching.
    -----------------------------------------------------------------------------
    Returns:
        A real number greater then one,that rapresent the return status of the matching operation
    -----------------------------------------------------------------------------
    Description:
		The function matches the antenna impedance passed in ReadPoint parameter.
		It can receives a flag 
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_FlagMatchReadPointImpedance(CAENRFIDHandle Handle, char* ReadPoint, CAENRFIDMatchingParams Flag, float *Status);

/*
    CAENRFID_GetReadPoints.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[out] Antennas		 : The names of the Antenna avalaible on the reader.
		[out] numAnt		 : The number of string in Antennas.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		The function permits to know the name of the antenna available on the reader.
		Names are formatted according to CAEN RFID communication protocol.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetReadPoints(CAENRFIDHandle Handle, char **Antennas[], int *numAnt);

/*
    CAENRFID_GetSourceNames.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[out] Sources		 : The names of the logical source avalaible on the reader.
		[out] numSrc		 : The number of string in logical sources.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		The function permits to know the name of the logical source available on the reader.
		Names are formatted according to CAEN RFID communication protocol.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetSourceNames(CAENRFIDHandle Handle, char **Sources[], int *numSrc);

/*
    CAENRFID_GetSourceInChannel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  ChannelName    : The name of the Channel.
        [out] isPresent      : A flag indicating if the source is associated to
                               the specified channel.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check if a logical source is associated to a
        specified notification channel that is, the data read from the source is
        sent to the channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetSourceInChannel(CAENRFIDHandle Handle, char* SourceName, char *ChannelName, short *isPresent);

/*
    CAENRFID_GetSourceInTrigger.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  TriggerName    : The name of the Trigger.
        [out] isPresent      : A flag indicating if the source is associated to
                               the specified trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check if a logical source is associated to a
        specified trigger.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetSourceInTrigger(CAENRFIDHandle Handle, char* SourceName, char *TriggerName, short *isPresent);

/*
    CAENRFID_GetTriggerInChannel.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TriggerName    : The name of the Trigger.
        [in]  ChannelName    : The name of the ChannelName.
        [out] isPresent      : A flag indicating if the trigger is associated to
                               the specified channel.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check if a trigger is associated to a
        specified notification channel.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetTriggerInChannel(CAENRFIDHandle Handle, char *TriggerName, char *ChannelName, short *isPresent);

/*
    CAENRFID_GetChannelInTrigger.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ChannelName    : The name of the ChannelName.
        [in]  TriggerName    : The name of the Trigger.
		[out] isPresent      : A flag indicating if the channel is associated to
                               the specified trigger.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check if a channel is associated to a
        specified notification trigger.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetChannelInTrigger(CAENRFIDHandle Handle, char *ChannelName, char *TriggerName, short *isPresent);


/*
    CAENRFID_GetReadPointInSource.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  ReadPoint      : The name of the Read Point.
        [out] isPresent      : A flag indicating if the read point is associated
                               to the specified source.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check if a read point is associated to a
        specified logical source that is, the read point is used within a read
        cycle performed in the source.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use GetReadPointPresent") CAENRFIDErrorCodes __stdcall
CAENRFID_GetReadPointInSource(CAENRFIDHandle Handle, char* ReadPoint, char* SourceName, short *isPresent);

/*
    CAENRFID_isReadPointPresent.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The name of the Logical Source.
        [in]  ReadPoint      : The name of the Read Point.
        [out] isPresent      : A flag indicating if the read point is associated
                               to the specified source.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to check if a read point is associated to a
        specified logical source that is, the read point is used within a read
        cycle performed in the source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_isReadPointPresent(CAENRFIDHandle Handle, char* ReadPoint, char* SourceName, short *isPresent);

/*
    CAENRFID_SetNetwork.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  IPAddress      : The IP address to set in the form XXX.XXX.XXX.XXX
        [in]  NetMask        : The netmask to set in the form XXX.XXX.XXX.XXX
        [in]  Gateway        : The Gateway to set in the form XXX.XXX.XXX.XXX
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to configure the network address, the netmask and
        the default gateway of the reader. The settings are activated after a
        reboot of the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetNetwork(CAENRFIDHandle Handle, char *IPAddress, char *NetMask, char *Gateway);

/*
    CAENRFID_GetNetwork.
    -----------------------------------------------------------------------------
    Parameters:
        [in]   Handle         : The handle that identifies the device.
        [out]  IPAddress      : The IP address in the form XXX.XXX.XXX.XXX
        [out]  NetMask        : The netmask in the form XXX.XXX.XXX.XXX
        [out]  Gateway        : The gateway address in the form XXX.XXX.XXX.XXX
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the network address, the netmask and
        the default gateway of the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetNetwork(CAENRFIDHandle handle, char* IpAddress, char* NetMask, char* Gateway);

/*
    CAENRFID_SetDE_SB.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  Enable         : Enable flag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to enable the use of the data exchange status bit in
        the ISO18000-6b anticollision algorithm.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SetDESB_ISO180006B instead") CAENRFIDErrorCodes __stdcall
CAENRFID_SetDE_SB(CAENRFIDHandle Handle, unsigned int Enable);

/*
    CAENRFID_GetDE_SB.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] Status         : The status flag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to know if the data exchange status bit is used in
        the ISO18000-6b anticollision algorithm.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetDE_SB(CAENRFIDHandle handle, unsigned short *Status);

/*
    CAENRFID_GetDESB_ISO180006B.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] Status         : The status flag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to know if the data exchange status bit is used in
        the ISO18000-6b anticollision algorithm.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetDE_SB(CAENRFIDHandle handle, unsigned short *Status);

/*
    CAENRFID_SetDESB_ISO180006B.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[in]  SourceName	 : The source name.
        [in]  Enable         : Enable flag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to enable the use of the data exchange status bit in
        the ISO18000-6b anticollision algorithm.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetDESB_ISO180006B(CAENRFIDHandle Handle, char* SourceName, int Enable);

/*
    CAENRFID_GetDESB_ISO180006B.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[in]  SourceName	 : The source name.
        [out] Status         : The status flag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to know if the data exchange status bit is used in
        the ISO18000-6b anticollision algorithm.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetDESB_ISO180006B(CAENRFIDHandle handle,char* SourceName,int *Status);


/*
    CAENRFID_ProgramID. (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TagID          : The EPC to program in the tag.
        [in]  Password       : The kill password to program in the tag.
        [in]  Lock           : Aflag indicating if the EPC has to be locked.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC Class 1 Gen 1 tag.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use ProgramID_EPC_C1G1 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_ProgramID(CAENRFIDHandle Handle, CAENRFIDTag *TagID, char Password, unsigned short Lock);

/*
    CAENRFID_ProgramID_EPC_C1G1. 
	-----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TagID          : The EPC to program in the tag.
        [in]  Password       : The kill password to program in the tag.
        [in]  Lock           : Aflag indicating if the EPC has to be locked.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC Class 1 Gen 1 tag.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ProgramID_EPC_C1G1(CAENRFIDHandle Handle, CAENRFIDTag *Tag, char Password, unsigned short Lock);

/*
    CAENRFID_KillTag. (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TagID          : The EPC of the tag.
        [in]  Password       : The kill password for the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to kill an EPC Class 1 Gen 1 tag.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use KillTag_EPC_C1G1 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_KillTag(CAENRFIDHandle Handle, CAENRFIDTag *TagID, char Password);

/*
    CAENRFID_KillTag_EPC_C1G1.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  Tag            : The tag to kill.
        [in]  Password       : The kill password for the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to kill an EPC Class 1 Gen 1 tag.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_KillTag_EPC_C1G1(CAENRFIDHandle Handle, CAENRFIDTag *Tag, char Password);


/*
    _CAENRFID_RFControl. **** EXPERIMENTAL ****
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  RFOn			 : 0 Disable RF >0 Enable
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to turn on/off the RF field.

		**** ATTENTION ****
		This function is for experimantal use only
		CAEN may delete it in the next release.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
_CAENRFID_RFControl(CAENRFIDHandle handle, unsigned int RFOn);


/*
    CAENRFID_BlockWrite(DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the memory to write.
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the memory of a
        specific tag identified by the ID (regardless of its status) at the
        address specified by Address.
		This function doesn't work with semi-passive tags
*/

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use BlockWriteTagData instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_BlockWrite(CAENRFIDHandle handle, CAENRFIDTag *ID, int Address, int Length, void *Data);


/*
    CAENRFID_BlockWriteTagData
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the memory to write.
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's user memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		This method can be used to write a portion of the user memory in a ISO18000-6B tag
        using blocks of four bytes for each command.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BlockWriteTagData(CAENRFIDHandle handle, CAENRFIDTag *ID, int Address, int Length, void *Data);

/*
    CAENRFID_FilterBlockWriteTagData
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Address   : The address of the memory to write.
		[in]  Mask		: A bitmask that permit to select which of the four bytes have to be written
						  (i.e. mask 0x05 writes the bytes on position Address + 1 and Address + 3)
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's user memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		This method can be used to write a portion of the user memory in a ISO18000-6B tag
        using blocks of four bytes for each command.You can provides a mask to select which
		of the four bytes has to be written.Only the 4 lsb are considered.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_FilterBlockWriteTagData(CAENRFIDHandle handle, CAENRFIDTag *ID, int Address, short Mask, int Length, void *Data);


/*
    CAENRFID_BlockWriteTagData_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  Tag       : The target tag.
        [in]  membank   : The bank to write the data to.
        [in]  Address	: The start address where to start writing the data.
        [in]  Length    : The length in byte of the single block of data to write.
        [in]  Data      : The data to write in the tag's user memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to optimize a writing operation on an ISO18000-6C 
        (EPC Class1 Gen2) tag's memory, writing data a block of bytes at time. It's
        an optional command, so before use it, please refer to the tag's manual.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BlockWriteTagData_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag* Tag, short membank, int Address, int BlockSize, int Length, void* Data);

/*
    CAENRFID_SecureBlockWriteTagData_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  Tag            : The target tag.
        [in]  membank        : The bank to write the data to.
        [in]  Address	     : The start address where to start writing the data.
        [in]  Length         : The length in byte of the single block of data to write.
        [in]  Data           : The data to write in the tag's user memory.
        [in]  AccessPassword : The access password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to optimize a writing operation on an ISO18000-6C
        (EPC Class1 Gen2) tag's memory, writing data a block of bytes at time. It's
        an optional command, so before use it, please refer to the tag's manual.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureBlockWriteTagData_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag* Tag, short membank, int Address, int BlockSize, int Length, void* Data, int AccessPassword);

/*
    CAENRFID_SetRS232.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		    : The handle that identifies the device.
        [in]  baud			    : The baudrate value.
        [in]  datab		        : The databit value.
        [in]  stopb             : The stopbit value.
        [in]  parity		    : The parity value.
        [in]  flowc		        : The flowcontrol value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to configure the serial communication of the reader
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetRS232(CAENRFIDHandle handle, unsigned long baud, unsigned long datab, unsigned long stopb, CAENRFID_RS232_Parity parity, CAENRFID_RS232_FlowControl flowc);

/*
    CAENRFID_SetAdminPassword.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SecurePassword : The administrator password for the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the admin password in the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetAdminPassword(CAENRFIDHandle handle, int SecurePassword);

/*
    CAENRFID_DoLogin.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
		[in]  SecurePassword : The administrator password for the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function grants the administrator's reader permission of the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_DoLogin(CAENRFIDHandle handle, int SecurePassword);

/*
    CAENRFID_DoLogout.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function revokes the administrator's reader permission of the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_DoLogout(CAENRFIDHandle handle);

/*
    CAENRFID_SetDateTime.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  datetime       : The current date ed time in the format: 
                               "yyyy-MM-dd HH:mm:ss" e.g. 2022-03-08 23:04:11
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the date e the time in the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetDateTime(CAENRFIDHandle handle, char *datetime);

/*
	CAENRFID_GetBufferedData.
	-----------------------------------------------------------------------------
	Parameters:
		[in] handle			: The handle that identifies the devices.
		[in] source			: The source channel to retrieve data from.
		[out] Receive		: The Tags readed from the source.
		[out] Size			: The number of tags readed.
	-----------------------------------------------------------------------------
	Returns:
		An error code about the execution of the function.
	-----------------------------------------------------------------------------
	Description:
		The function retrieves all the tags contained in the internal buffer of
		reader.The reader should have an embedded buffer.See the reader's tech
		manual for relative details.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetBufferedData(CAENRFIDHandle handle,char * source,CAENRFIDTag **Receive, int *Size);

/*
	CAENRFID_GetBufferedDataRange.
	-----------------------------------------------------------------------------
	Parameters:
		[in] handle			: The handle that identifies the devices.
		[in] source			: The source channel to retrieve data from.
		[in] address		: The zero-based position in the internal buffer from
		                      which starts to read.
	    [in] length			: The number of records to retrive starting from the
							  address parameter.
		[out] Receive		: The Tags readed from the source.
		[out] Size			: The number of tags readed.
	-----------------------------------------------------------------------------
	Returns:
		An error code about the execution of the function.
	-----------------------------------------------------------------------------
	Description:
		The function retrieves all the tags contained in the internal buffer of
		reader starting from a certain record's offset and for a certain number.
		The reader should have an embedded buffer.See the reader's tech manual 
		for relative details.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetBufferedDataRange(CAENRFIDHandle handle,char * source, int address, int length, CAENRFIDTag **Receive, int *Size);

/*
	CAENRFID_GetBufferSize.
	-----------------------------------------------------------------------------
	Parameters:
		[in]  handle		: The handle that identifies the devices.
		[out] Size			: The number of records contained in the internal buffer. 
	-----------------------------------------------------------------------------
	Returns:
		An error code about the execution of the function.
	-----------------------------------------------------------------------------
	Description:
		The function retrieves the number tags stored in the internal buffer of
		the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetBufferSize (CAENRFIDHandle handle, unsigned int *size);

/*
	CAENRFID_ClearBuffer.
	-----------------------------------------------------------------------------
	Parameters:
		[in] handle			: The handle that identifies the devices.
	-----------------------------------------------------------------------------
	Returns:
		An error code about the execution of the function.
	-----------------------------------------------------------------------------
	Description:
		The function clear all the records contained in the internal's internal
		buffer.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ClearBuffer (CAENRFIDHandle handle);




CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
_CAENRFID_GroupSelUnsel(CAENRFIDHandle handle, char* SourceName, CAENRFID_SelUnsel_Op code, int Address, int BitMask, void *data, CAENRFIDTag *ID);


/*
    CAENRFID_GetIO.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] IORegister     : The current IO Register.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to read the IO register.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetIO(CAENRFIDHandle handle, unsigned int *IORegister);

/*
    CAENRFID_SetIO.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  IORegister     : The IO Register value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to write the IO register.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetIO(CAENRFIDHandle handle, unsigned int IORegister);

/*
	CAENRFID_GetChannelStatus
	-----------------------------------------------------------------------------
	Parameters:
	[in]  Handle         : The handle that identifies the device.
	[in]  channelname    : The name of the channel
	[out] status		 : The status of the channel
	-----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Check if the notification channel is busy or not.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetChannelStatus(CAENRFIDHandle handle,char *channelname , unsigned short *status);

/*
    CAENRFID_GetIODirection.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] IODirection     : The current IO Direction.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to read the IO direction of IORegister.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetIODirection(CAENRFIDHandle handle, unsigned int *IODirection);

/*
    CAENRFID_SetIODirection.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  IODirection     : The IO Direction value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the IO Direction for the IORegister.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetIODirection(CAENRFIDHandle handle, unsigned int IODirection);

/*
    CAENRFID_SetSourceConfiguration.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The Name of the Logical Source.
        [in]  parameter      : The parameter of Logical Source to configure.
        [in]  value          : The the value of the parameter.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to configure the Logical Source.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes  __stdcall
CAENRFID_SetSourceConfiguration(CAENRFIDHandle handle, char* SourceName, CAENRFID_SOURCE_Parameter parameter, int value);

/*
		THIS function is NOT exported.
        The function permits to configure the Logical Source.
*/
CAENRFIDErrorCodes  __stdcall
CAENRFID_SetSourceConf(CAENRFIDHandle handle, char* SourceName, CAENRFID_SOURCE_Parameter parameter, int value);


/*
    CAENRFID_GetSourceConfiguration.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName     : The Name of the Logical Source.
        [in]  parameter      : The parameter of Logical Source to configure.
        [out] value          : The the value of the parameter.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the value of the Logical Source configuration.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetSourceConfiguration(CAENRFIDHandle handle, char* SourceName, CAENRFID_SOURCE_Parameter parameter, int *pvalue);

/*
	 THIS function is NOT exported.The function permits to get the value 
	 of the Logical Source configuration.
*/
CAENRFIDErrorCodes __stdcall
CAENRFID_GetSourceConf(CAENRFIDHandle handle, char* SourceName, CAENRFID_SOURCE_Parameter parameter, int *pvalue);

/*
    CAENRFID_GetAllocatedTriggers.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] TriggerNum     : The number of triggers allocated.
        [out] Triggers       : The Triggers's names of allocated triggers.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the allocated triggers.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetAllocatedTriggers(CAENRFIDHandle handle, int *TriggerNum, char **Triggers);

/*
    CAENRFID_GetAllocatedChannels.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] ChannelNum     : The number of channels allocated.
        [out] Channels       : The channels's names of allocated channels.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the allocated channels.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetAllocatedChannels(CAENRFIDHandle handle, int *ChannelNum, char **Channels);


/*
    CAENRFID_SetEventMode. (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  EMode			 : The Event Mode.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the Event Generation Mode of the reader.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_SetEventMode(CAENRFIDHandle handle, CAENRFID_EventMode EMode);

/*
    CAENRFID_GetEventMode. (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] EMode			 : The Event Mode of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the Event Generation Mode of the reader.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetEventMode(CAENRFIDHandle handle, CAENRFID_EventMode *EMode);


/*
    CAENRFID_FirmwareUpgrade.(DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  type			 : The kind of upgrading
        [in]  arg			 : The argument for the upgrading
								in the form '[tftpserver ip]:[filename]'
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to upgrade the reader's firmware.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_FirmwareUpgrade(CAENRFIDHandle handle, CAENRFID_FWUpgradeType type, char *arg);

/*
    CAENRFID_ResetSession_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The name of the logical suorce where reset the session.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to reset the Session status for EPC Class1 Gen2 tags.
        After the execution of this method all the tags in the field of the antennas belonging
        to this logical source are back in the default Session.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ResetSession_EPC_C1G2(CAENRFIDHandle handle, char* SourceName);
/*
    CAENRFID_Lock_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  Payload   : The payload of the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to lock the memory of a
        specific tag identified by the ID and by Payload.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use LockTag_EPC_C1G2") CAENRFIDErrorCodes __stdcall
CAENRFID_Lock_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, int payload);

/*
    CAENRFID_LockTag_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag to lock.
        [in]  Payload   : The payload of the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to lock the memory of a
        specific tag identified by the ID and by Payload.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_LockTag_EPC_C1G2(CAENRFIDHandle Handle, CAENRFIDTag *Tag, int Payload);

/*
    CAENRFID_BankFilteredLock_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
		[in]  SourceName	: The source where the tag has been detected.
        [in]  BankMask		: The bank where apply the mask filter.
		[in]  PositionMask	: The position where start the mask (bit oriented).
		[in]  LengthMask	: The number of significant bits of Mask from its start.
		[in]  Mask			: The mask filter array.
		[in]  MaskLen		: The length in bytes of Mask.
		[in]  Payload		: The Payload bitmask.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to lock the memory of a specific tag identified 
		by the bank parameters using Payload bitmask.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BankFilteredLock_C1G2(CAENRFIDHandle handle,char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask, int MaskLen, int Payload);

/*
    CAENRFID_KillTag_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  TagID          : The EPC of the tag.
        [in]  Password       : The password for the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to kill an EPC Class 1 Gen 2 tag.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use KillTag_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_KillTag_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, int password);

/*
    CAENRFID_KillTag_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  Tag            : The tag to kill.
        [in]  Password       : The password for the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to kill an EPC Class 1 Gen 2 tag.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_KillTag_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag, int password);

/*
    CAENRFID_BankFilteredKillTag_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
		[in]  SourceName	: The source where the tag has been detected.
        [in]  BankMask		: The bank where apply the mask filter.
		[in]  LengthMask	: The number of significant bits of Mask from its start.
		[in]  Mask			: The mask filter array.
		[in]  MaskLen		: The length in bytes of Mask.
		[in]  KillPassword	: The Kill password.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to kill an EPC Class 1 Gen 2 tag, identified
		by bank parameters.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BankFilteredKillTag_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask, int MaskLen, int KillPassword);


/*
    CAENRFID_SetReadCycle.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where set the readcyle paramter.
        [in]  value			 : The number of read cycles.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Sets the number of read cycles to be performed by the logical source 
         during the inventory algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetReadCycle(CAENRFIDHandle handle, char* SourceName, int value);
/*
    CAENRFID_GetReadCycle.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where get the readcyle paramter.
        [out]  value			 : The number of read cycles.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Gets the number of read cycles performed by the logical source 
         during the inventory algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetReadCycle(CAENRFIDHandle handle, char* SourceName, int * value);


/*
    CAENRFID_SetSelected_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where set the readcyle paramter.
        [in]  value			 : The Selected flag value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to set the Selected flag (see EPC Class1 Gen2 protocol specification)
        used by the anticollision algorithm when called on this logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetSelected_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, CAENRFIDLogicalSourceConstants value);
/*
    CAENRFID_GetSelected_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where get the readcyle paramter.
        [out]  value		 : The Selected flag value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to get the Selected flag (see EPC Class1 Gen2 protocol specification)
        used by the anticollision algorithm when called on this logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetSelected_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, CAENRFIDLogicalSourceConstants * value);

/*
    CAENRFID_SetSession_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where set the readcyle paramter.
        [in]  value			 : The Session value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to set the Session (see EPC Class1 Gen2 protocol specification)
        used by the anticollision algorithm when called on this logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetSession_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, CAENRFIDLogicalSourceConstants value);
/*
    CAENRFID_GetSession_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where get the readcyle paramter.
        [out]  value		 : The Session value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to get the Session (see EPC Class1 Gen2 protocol specification)
        used by the anticollision algorithm when called on this logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetSession_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, CAENRFIDLogicalSourceConstants * value);

/*
    CAENRFID_SetTarget_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where set the readcyle paramter.
        [in]  value			 : The Target value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to set the Target setting (see EPC Class1 Gen2 protocol specification)
        used by the anticollision algorithm when called on this logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetTarget_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, CAENRFIDLogicalSourceConstants value);
/*
    CAENRFID_GetTarget_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  SourceName	 : The logical source where get the readcyle paramter.
        [out]  value		 : The Target value.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to get the Target setting (see EPC Class1 Gen2 protocol specification)
        used by the anticollision algorithm when called on this logical source.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetTarget_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, CAENRFIDLogicalSourceConstants * value);

/*
    CAENRFID_ProgramID_EPC119.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ID			 : The actual ID of the tag.
        [in]  NewID			 : The new ID for the specified tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC 119 tag.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ProgramID_EPC119(CAENRFIDHandle handle, CAENRFIDTag *ID, char *NewID );

/*
    CAENRFID_ProgramID_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ID			 : The EPC to program in the tag.
        [in]  nsi            : The NSI value for the EPC C1G2.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC Class 1 Gen 2 tag.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use ProgramID_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_ProgramID_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, unsigned short nsi );

/*
    CAENRFID_ProgramID_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ID			 : The EPC to program in the tag.
        [in]  nsi            : The NSI value for the EPC C1G2.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC Class 1 Gen 2 tag.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ProgramID_EPC_C1G2(CAENRFIDHandle Handle, CAENRFIDTag *Tag, unsigned short nsi );


/*
  CAENRFID_BlockProgramID_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ID			 : The EPC to program in the tag.
        [in]  NSI            : The NSI value for the EPC C1G2.
        [in]  blockLength    : The length in byte of a single block of data. 
                               It should be a multiple of 2. 
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to optimize a programming operation on an ISO18000-6C (EPC Class1 Gen2) tag's ID space,
        writing data a block of bytes at time. It's an optional command, so before use it, please refer to the tag's manual.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BlockProgramID_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag* Tag, unsigned short nsi, unsigned short blockLength);

/*
  CAENRFID_SecureBlockProgramID_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  ID			 : The EPC to program in the tag.
        [in]  NSI            : The NSI value for the EPC C1G2.
        [in]  blockLength    : The length in byte of a single block of data.
                               It should be a multiple of 2.
        [in]  AccessPassword : The access password.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This method can be used to optimize a programming operation on an ISO18000-6C (EPC Class1 Gen2) tag's ID space,
        writing data a block of bytes at time. It's an optional command, so before use it, please refer to the tag's manual.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureBlockProgramID_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag* Tag, unsigned short nsi, unsigned short blockLength, int AccessPassword);

/*
    CAENRFID_Read_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
        [in]  membank	: The memory Bank of EPC C1G2 Tag
        [in]  Address   : The address of the memory to read.
        [in]  Length    : The number of bytes to read.
        [out] Data      : The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to read Length bytes from the bank memory,
        specified by membank, of a specific tag identified by the
        ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use ReadTagData_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_Read_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, short membank, int Address, int Length, void *Data);

/*
    CAENRFID_Read_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag.
		[in]  membank	: The memory Bank of EPC C1G2 Tag
        [in]  Address   : The address of the memory to read.
        [in]  Length    : The number of bytes to read.
        [out] Data      : The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to read Length bytes from the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ReadTagData_EPC_C1G2(CAENRFIDHandle Handle, CAENRFIDTag *Tag, short Membank, int Address, int Length, void *Data);

/*
    CAENRFID_Write_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  ID        : The tag ID.
		[in]  membank	: The memory Bank of EPC C1G2 Tag
        [in]  Address   : The address of the memory to write.
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use WriteTagData_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_Write_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, short membank,int Address, int Length, void *Data);

/*
    CAENRFID_WriteTagData_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  Tag        : The tag ID.
		[in]  membank	: The memory Bank of EPC C1G2 Tag
        [in]  Address   : The address of the memory to write.
        [in]  Length    : The number of bytes to write.
        [in]  Data      : The data to write in the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_WriteTagData_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag, short membank,int Address, int Length, void *Data);


/*
    CAENRFID_BankFilteredRead_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
        [in]  SourceName	: The source where the tag has been detected.
		[in]  BankMask		: The bank where apply the mask filter.
		[in]  PositionMask	: The position where start the mask (bit oriented).
		[in]  LengthMask	: The lenght of the meaning bits of Mask from its start.
		[in]  Mask			: The mask filter array
		[in]  MaskLen		: The number of bytes passed in Mask.
		[in]  Membank		: The memory Bank of EPC C1G2 Tag
        [in]  Address		: The address of the memory to read.
        [in]  Length		: The number of bytes to read.
        [out] Data			: The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to read Length bytes from the bank memory of a tag,
		specified by Membank, identified by BankMask,PositionMask,LengthMask and Mask,from the 
		address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BankFilteredReadTagData_EPC_C1G2(CAENRFIDHandle Handle,char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask, int MaskLen, short MemBank, int Address, int Length, void *Data);

/*
    CAENRFID_BankFilteredWrite_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
		[in]  SourceName	: The source where the tag has been detected.
        [in]  BankMask		: The bank where apply the mask filter.
		[in]  PositionMask	: The position where start the mask (bit oriented).
		[in]  LengthMask	: The meaning length in bit of Mask from its start.
		[in]  Mask			: The mask filter array
		[in]  MaskLen		: The length in bytes of passed Mask.
		[in]  membank		: The memory Bank of EPC C1G2 Tag
        [in]  Address		: The address of the memory to write.
        [in]  Length		: The number of bytes to write.
        [in]  Data			: The data to write in the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the bank memory,
		specified by membank, of a specific tag identified by the 
		bank paramters(bankMask,PositionMask,LengthMask,Mask) at the 
		address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BankFilteredWriteTagData_EPC_C1G2(CAENRFIDHandle handle,char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask, int MaskLen, short MemBank,int Address, int Length, void *Data);

/*
    CAENRFID_QueryTag_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [out] isPresent      : A flag indicating if the tag answered at Query command
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to perform the Query command of C1G2 protocol
*/

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use QueryTag_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_QueryTag_C1G2(CAENRFIDHandle handle, char* SourceName, short *isPresent);

/*
    CAENRFID_QueryTag_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [out] isPresent      : A flag indicating if the tag answered at Query command
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to perform the Query command of C1G2 protocol
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_QueryTag_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, short *isPresent);

/*
    CAENRFID_SetQ_C1G2 (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Q     : The value of Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the Q parameter of C1G2 protocol
*/

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use CAENRFID_SetQValue_EPC_C1G2 instead") CAENRFIDErrorCodes __stdcall
CAENRFID_SetQ_C1G2(CAENRFIDHandle handle, int Q);

/*
    CAENRFID_GetQ_C1G2 (DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [out]  Q     : The value of Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the Q parameter of C1G2 protocol
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use CAENRFID_GetQValue_EPC_C1G2 instead") CAENRFIDErrorCodes __stdcall
CAENRFID_GetQ_C1G2(CAENRFIDHandle handle, int *Q);

/*
    CAENRFID_SetQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [in]  Q     : The value of Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the Q parameter of C1G2 protocol
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int Q);

/*
    CAENRFID_GetQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [out]  Q     : The value of Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the Q parameter of C1G2 protocol
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int *Q);


/*
    CAENRFID_SetMinQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [in]  Q     : The value of minimum Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the minimum Q parameter of C1G2 protocol
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetMinQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int Q);

/*
    CAENRFID_GetMinQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [out]  Q     : The value of minimum Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the minimum Q parameter of C1G2 protocol
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetMinQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int* Q);


/*
    CAENRFID_SetMaxQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [in]  Q     : The value of maximum Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the maximum Q parameter of C1G2 protocol
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetMaxQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int Q);

/*
    CAENRFID_GetMaxQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [out]  Q     : The value of maximum Q.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the maximum Q parameter of C1G2 protocol
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetMaxQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int* Q);


/*
    CAENRFID_SetNumMinQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [in]  Q              : The value of the num min Q parameter
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
         The function permits to set the number of last inventory round when Q is at minimum value.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetNumMinQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int Q);

/*
    CAENRFID_GetNumMinQValue_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  SourceName     : The Name of the Logical Source.
        [out]  Q     : The value of the num min Q parameter
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the number of last inventory round when Q is at minimum value.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetNumMinQValue_EPC_C1G2(CAENRFIDHandle handle, char* SourceName, int* Q);



/*
	CAENRFID_SetTIDLength
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [out]  initLength     : The initial TID Length.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the initial TID length. When used on inventory, 
		with TID_READING flag enable, the reader try to read TID memory from initLength
		to the max length reaches with no TID membank reading error.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetTIDLength(CAENRFIDHandle handle, char* SourceName, int initLength);

/*
	CAENRFID_GetTIDLength
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [out]  initLength     : The initial TID Length.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the initial TID length. When used on inventory, 
		with TID_READING flag enable, the reader try to read TID memory from initLength
		to the max length reaches with no TID membank reading error.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetTIDLength(CAENRFIDHandle handle, char* SourceName, int *initLength);

/*
	CAENRFID_SetInventoryCounts
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [in]  value          : The number of read cycles
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function sets the number of inventory counts to be performed by the
		logical source after pressing the TRIGGER button during the inventory 
		algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetInventoryCounts(CAENRFIDHandle handle, char* SourceName, int value);

/*
	CAENRFID_GetInventoryCounts
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [out] Counts          : The number of read cycles
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function gets the number of inventory counts to be performed by the
		logical source after pressing the TRIGGER button during the inventory 
		algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetInventoryCounts(CAENRFIDHandle handle, char* SourceName, int *Counts);

/*
	CAENRFID_SetInventoryDwellTime
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [in]  value          : Inventory execution time (msec).
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function sets the inventory execution time (msec) used by the logical
		source during the inventory algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetInventoryDwellTime(CAENRFIDHandle handle, char* SourceName, int value);

/*
	CAENRFID_GetInventoryDwellTime
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [out]  value         : Inventory execution time (msec).
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function gets the inventory execution time (msec) used by the logical
		source during the inventory algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetInventoryDwellTime(CAENRFIDHandle handle, char* SourceName, int *value);

/*
	CAENRFID_SetInventoryQuietTime
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [in]  value          : Inventory quiet time (msec).
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function sets the inventory quiet time (msec) used by the logical
		source during the inventory algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetInventoryQuietTime(CAENRFIDHandle handle, char* SourceName, int value);
/*
	CAENRFID_GetInventoryQuietTime
    -----------------------------------------------------------------------------
    Parameters:
		[in]  SourceName     : The Name of the Logical Source.
        [out]  value         : Inventory quiet time (msec).
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function gets the inventory quiet time (msec) used by the logical
		source during the inventory algorithm execution.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetInventoryQuietTime(CAENRFIDHandle handle, char* SourceName, int *value);

/*
    CAENRFID_GetReaderInfo
    -----------------------------------------------------------------------------
    Parameters:
        [out] Model : 		Returns the model of the reader.
        [out] SerialNum : 	Returns the Serial number of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Permits to read the Model and the Serial number of the Reader.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetReaderInfo(CAENRFIDHandle handle, char *Model, char *SerialNum);

/*
    CAENRFID_GetReaderInfoLevel
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Level :       It's a number that specifies the level of internal rfid module
                            module embedded inside the reader from which getting info.
        [out] Model : 		Returns the model of the reader.
        [out] SerialNum : 	Returns the Serial number of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        Permits to read the Model and the Serial number of the Reader, or one of it's
        internal module. Typical value is limited to 1. Call this function with Level = 0,
        it's equivalent to call CAENRFID_GetReaderInfo(CAENRFIDHandle, char*, char*).
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetReaderInfoLevel(CAENRFIDHandle handle, short level, char* Model, char* SerialNum);



/*
    CAENRFID_InventoryTag.(DEPRECATED)
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  SourceName : The name that identify the Logical Source
        [out] Receive  : Returns an array containing the tags read.
        [out] Size     : Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_InventoryTag (CAENRFIDHandle handle, char* SourceName, CAENRFIDTag **Receive, int *Size);

/*
    CAENRFID_GetLBTMode.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] LBTMode		 : The ListenBeforeTalk Mode of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to get the The ListenBeforeTalk Mode of the reader.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use CAENRFID_GetFHSSMode instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetLBTMode(CAENRFIDHandle handle, unsigned short *LBTMode);

/*
    CAENRFID_SetLBTMode.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  LBTMode        : The ListenBeforeTalk Mode of the reader.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to change the The ListenBeforeTalk Mode of the reader.
*/

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use CAENRFID_SetFHSSMode instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_SetLBTMode(CAENRFIDHandle handle, unsigned short LBTMode);

/*
    CAENRFID_GetFHSSMode.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [out] FHSSMode		 : A zero value if the FHSS is disabled, non-zero value 
		                       if it is enabled.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function indicates the activation of the frequency hopping mode of 
		the reader.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetFHSSMode(CAENRFIDHandle handle, unsigned short *FHSSMode);

/*
    CAENRFID_SetFHSSMode.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle         : The handle that identifies the device.
        [in]  FHSSMode       : A zero value to disable FHSS, non-zero value 
		                       to enable FHSS.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to enable/disable the frequency hopping mode of 
		the reader.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetFHSSMode(CAENRFIDHandle handle, unsigned short FHSSMode);



/*
    CAENRFID_GetChannelData.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  handle         : The handle that identifies the device.
		[in]  ChannelName    : The name of the ChannelName that is memorizing the data.
        [out] TagsDetected   : A list of data items.
        [out] NumberItemsNotified : The number of data items in the list..
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to retrieve the data memorized by a Channel (Memory Mode).
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_GetChannelData(CAENRFIDHandle handle, char *ChannelName, CAENRFIDNotify **TagsDetected, int *NumberItemsNotified);

/*
    CAENRFID_FreeTagsMemory.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Tags         : Reference to CAENRFIDTag obtained from CAENRFIDInventory 
							 or CAENRFID_InventoryTag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to free the allocated by CAENRFIDInventory or 
		by CAENRFID_InventoryTag.
*/
CAENRFIDlib_API void __stdcall
CAENRFID_FreeTagsMemory(CAENRFIDTag **Tags);

/*
    CAENRFID_GetRFChannel.
    -----------------------------------------------------------------------------
    Parameters:
		[in]  handle    : The handle that identifies the device.
        [out] RFChannel : The RFChannel
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to retrieve the RFChanel.
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetRFChannel(CAENRFIDHandle handle, unsigned short *RFChannel);

/*
    CAENRFID_SetRFChannel.
    -----------------------------------------------------------------------------
    Parameters:
		[in]  handle    : The handle that identifies the device.
        [in]  RFChannel : The RFChannel
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the RFChanel.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetRFChannel(CAENRFIDHandle handle, unsigned short RFChannel);

/*
    CAENRFID_GetRFRegulation.
    -----------------------------------------------------------------------------
    Parameters:
		[in]  handle		: The handle that identifies the device.
        [out] RFRegulation  : The RFRegulation
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to retrieve the RFRegulation.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_GetRFRegulation(CAENRFIDHandle handle, CAENRFIDRegulations *RFRegulation);

/*
    CAENRFID_SetRFRegulation.
    -----------------------------------------------------------------------------
    Parameters:
		[in]  handle		: The handle that identifies the device.
        [in]  RFRegulation  : The RFRegulation
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to set the RFRegulation.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SetRFRegulation(CAENRFIDHandle handle, CAENRFIDRegulations RFRegulation);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_EM4325_GetUID(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte *UID, int *UIDLength);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureEM4325_GetUID(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte *UID, int *UIDLength,int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_EM4325_GetSensorData(CAENRFIDHandle handle, CAENRFIDTag *Tag, BOOL UIDEnable, byte *UID, int *UIDLength, BOOL NewSample, byte *Sensor, byte *UTC);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_EM4325_SendSPI(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte SPIConfig, byte *SPICmd, int SPICmdLen, int SlaveSPILength, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureEM4325_SendSPI(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte SPIConfig, byte* SPICmd, int SPICmdLen, int SlaveSPILength, int SecurePassword, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureEM4325_ResetAlarms(CAENRFIDHandle handle, CAENRFIDTag *Tag, int SecurePassword);    

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ISO180006C_BroadcastSync(CAENRFIDHandle handle, byte *UTC);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_Initialize(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned short DelayTime, unsigned short  ApplicationData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_SetLog(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned int LogMode);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_StartLog(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned int StartTime);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_EndLog(CAENRFIDHandle handle, CAENRFIDTag *Tag);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_GetLogState(CAENRFIDHandle handle, CAENRFIDTag *Tag, BOOL ShelfLife, char * TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Oridao_Begin(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned short *result);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureOridao_Begin(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned short *result,int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Oridao_Command(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned short cchandle, unsigned short WriteLengthBit, byte * WriteData, unsigned short ReplyLengthBit);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Oridao_End(CAENRFIDHandle handle, CAENRFIDTag *Tag);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_GetSensorValue(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte SensorType, CAENRFID_IDSTagData * IDSTagData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_SetLogLimits(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte *LogLimits, int LogLimitsLength);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_GetMeasurementSetup(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte **SetupData, int *SetupDataLength);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_GetCalibrationData(CAENRFIDHandle handle, CAENRFIDTag* Tag, byte* CalibrationData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_OpenArea(CAENRFIDHandle handle, CAENRFIDTag* Tag, byte PasswordLevel, int Password);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_IDS_SL900A_GetBatteryLevel(CAENRFIDHandle handle, CAENRFIDTag* Tag, BOOLEAN BatteryTypeRecheck, byte* result);

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use QueryAck_EPC_C1G2 instead.")CAENRFIDErrorCodes __stdcall
CAENRFID_QueryAck_C1G2(CAENRFIDHandle handle, char* SourceName, byte *id);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_QueryAck_EPC_C1G2(CAENRFIDHandle Handle, char* SourceName, byte *id);

/*
    CAENRFID_Untraceable_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  handle		: The handle that identifies the device.
		[in]  SourceName    : The name that identify the Logical Source
		[in]  Tag           : The CAENRFIDTag representing the tag to be untraced.
		[in]  u				: A boolean value for the U bit in XPC_W1 word.
		[in]  hideEPC       : Specify whether a Tag untraceably hides part 
		                      of EPC memory.
	    [in]  hideTID       : Specify whether a Tag untraceably hides part of TID 
	 	                      memory (allowed values: 0,1,2).
	    [in]  hideUser      : Specify whether a Tag untraceably hides part of USER 
		                      memory.
		[in]  range         : A value specifying a tags operating range in terms
		                      of reading distance (allowed values: 0,1,2).
	    [in]  newEPCLen     : A value specifying a new EPC length field.
		[in]  password      : The access password.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function allows an interrogator with an asserted Untraceable  
        privilege to instruct a Tag to (a) alter the L and U bits in EPC memory,
		(b) hide memory from interrogators with a deasserted Untraceable 
		privilege and/or (c) reduce its operating range for all interrogators.  
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Untraceable_EPC_C1G2(CAENRFIDHandle Handle,  char* SourceName, CAENRFIDTag *Tag, BOOL u, BOOL hideEPC, byte hideTID, BOOL hideUser, unsigned short range, unsigned short newEPCLen, int password);

/*
    CAENRFID_Authenticate_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  handle		: The handle that identifies the device.
		[in]  SourceName    : The name that identify the Logical Source
		[in]  Tag           : The CAENRFIDTag representing the tag to be authenticated.
		[in]  senRep		: Specifies whether a tag backscatters its response 
		                      or first stores the response in its ResponseBuffer
							  and then returns the data from there.
		[in]  incRepLen     : Specifies whether a tag omits or includes the 
		                      response length in its reply.
	    [in]  csi           : Selects the cryptographic suite that tag and 
		                      interrogator use for the authentication.
	    [in]  challenge     : It includes parameters and data for the 
		                      authentication.
		[in]  repLen        : Specify the byte's length of the tag's response.
		[in]  password      : The access password.
	    [out] authResponse  : A byte array containing the tag's response to the 
		                      authenticate command.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function allows an interrogator to perform tag, interrogator or mutual
		authentication. 
        The generic nature of the authenticate command allows it to support a 
		variety of cryptographic suites. The number of authenticate commands 
		required to implement an authentication depends on the authentication 
		type and on the chosen cryptographic suite.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Authenticate_EPC_C1G2(CAENRFIDHandle Handle, char *SourceName, CAENRFIDTag *Tag, BOOL senRep, BOOL incRepLen, char csi, byte *challenge, short challengeLen, short repLen, int password, byte **authResponse);


/*
    CAENRFID_FreeNotifyMemory.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  ItemsNotified : Reference to CAENRFIDNotify obtained from 
							  CAENRFID_GetNotification or CAENRFID_GetChannelData.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to free the allocated by CAENRFID_GetNotification or 
		CAENRFID_GetChannelData functions.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") void __stdcall
CAENRFID_FreeNotifyMemory(CAENRFIDNotify **ItemsNotified);

/*
    CAENRFID_SecureProgramID_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The EPC to program in the tag.
        [in]  nsi				: The NSI value for the EPC C1G2.
		[in]  Pwd				: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC Class 1 Gen 2 tag setting the secure password.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SecureProgramID_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_SecureProgramID_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, unsigned short nsi, int Pwd);

/*
    CAENRFID_SecureProgramID_EPC_C1G2.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The EPC to program in the tag.
        [in]  nsi				: The NSI value for the EPC C1G2.
		[in]  Pwd				: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function permits to program an EPC Class 1 Gen 2 tag setting the secure password.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureProgramID_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned short nsi, int AccessPassword);


/*
    CAENRFID_SecureRead_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
		[in]  membank			: The memory Bank of EPC C1G2 Tag
        [in]  Address			: The address of the memory to read.
        [in]  Length			: The number of bytes to read.
		[in]  Pwd				: The access Password
        [out] Data				: The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to Secure read Length bytes from the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SecureReadTagData_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_SecureRead_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID,short membank, int Address, int Length, int Pwd, void *Data);

/*
    CAENRFID_SecureReadTagData_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  Tag				: The tag.
		[in]  membank			: The memory Bank of EPC C1G2 Tag
        [in]  Address			: The address of the memory to read.
        [in]  Length			: The number of bytes to read.
		[in]  AccessPassword				: The access Password
        [out] Data				: The data read from the tag's memory.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to Secure read Length bytes from the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureReadTagData_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag,short membank, int Address, int Length, int AccessPassword, void *Data);


/*
    CAENRFID_SecureWrite_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
		[in]  membank			: The memory Bank of EPC C1G2 Tag
        [in]  Address			: The address of the memory to write.
        [in]  Length			: The number of bytes to write.
        [in]  Data				: The data to write in the tag's memory.
		[in]  Pwd				: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to secure write Length bytes to the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SecureWriteTagData_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_SecureWrite_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, short membank,int Address, int Length, void *Data, int Pwd);

/*
    CAENRFID_SecureWriteTagData_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  Tag				: The tag ID.
		[in]  membank			: The memory Bank of EPC C1G2 Tag
        [in]  Address			: The address of the memory to write.
        [in]  Length			: The number of bytes to write.
        [in]  Data				: The data to write in the tag's memory.
		[in]  AccessPassword	: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to secure write Length bytes to the bank memory,
		specified by membank, of a specific tag identified by the
		ID (regardless of its status) at the address specified by Address.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureWriteTagData_EPC_C1G2(CAENRFIDHandle Handle, CAENRFIDTag *Tag, short membank,int Address, int Length, void *Data, int AccessPassword);



/*
    CAENRFID_SecureLock_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
        [in]  Payload			: The payload of the tag's memory.
		[in]  Pwd				: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to secure lockthe memory of a
        specific tag identified by the ID and by Payload.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SecureLockTag_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_SecureLock_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, int payload, int Pwd);

/*
    CAENRFID_SecureLockTag_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  Tag				: The tag.
        [in]  Payload			: The payload of the tag's memory.
		[in]  AccessPssword		: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to secure lockthe memory of a
        specific tag identified by the ID and by Payload.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureLockTag_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag, int payload, int AccessPassword);

/*
CAENRFID_SecureBankFilteredLock_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
        [in]  SourceName	: The source where the tag has been detected.
		[in]  BankMask		: The bank where apply the mask filter.
		[in]  PositionMask	: The position where start the mask (bit oriented).
		[in]  LengthMask	: The number of significant bits of Mask from its start.
		[in]  Mask			: The mask filter array.
		[in]  MaskLen		: The length in bytes of Mask.
		[in]  Payload		: the payload bitmask.
		[in]  Pwd			: The access Password.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to secure lock the memory of a
        specific tag, identified by the bank parameters, with Payload bitmask.
		This is the secure version.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureBankFilteredLockTag_EPC_C1G2(CAENRFIDHandle Handle,char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask, int MaskLen, int Payload,int AccessPassword);


/*
    CAENRFID_SecureBankFilteredRead_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
        [in]  SourceName	: The source where the tag has been detected.
		[in]  BankMask		: The bank where apply the mask filter.
		[in]  PositionMask	: The position where start the mask (bit oriented).
		[in]  LengthMask	: The length of the mask in word.
		[in]  Mask			: The mask filter array
		[in]  membank		: The memory Bank of EPC C1G2 Tag
        [in]  Address		: The address of the memory to read.
        [in]  Length		: The number of bytes to read.
        [out] Data			: The data read from the tag's memory.
		[in]  Pwd			: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to read Length bytes from the bank memory,
		specified by membank, of a specific tag identified by the
		the bank paramters(bankMask,PositionMask,LengthMask,Mask) at the 
		address specified by Address.
		This is the secure version.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureBankFilteredReadTagData_EPC_C1G2(CAENRFIDHandle handle,char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask,int MaskLen, short membank, int Address, int Length, void *Data,int Pwd);

/*
    CAENRFID_SecureBankFilteredWrite_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle		: The handle that identifies the device.
		[in]  SourceName	: The source where the tag has been detected.
        [in]  BankMask		: The bank where apply the mask filter.
		[in]  PositionMask	: The position where start the mask (bit oriented).
		[in]  LengthMask	: The meaning length in bit of Mask from its start.  
		[in]  Mask			: The mask filter array
		[in]  MaskLen		: The number of bytes of Mask.
		[in]  membank		: The memory Bank of EPC C1G2 Tag
        [in]  Address		: The address of the memory to write.
        [in]  Length		: The number of bytes to write.
        [in]  Data			: The data to write in the tag's memory.
		[in]  AccessPassword: The access Password
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        This function allows to write Length bytes to the bank memory,
		specified by membank, of a specific tag identified by the 
		bank paramters(bankMask,PositionMask,LengthMask,Mask) at the 
		address specified by Address.
		This is the secure version.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureBankFilteredWriteTagData_EPC_C1G2(CAENRFIDHandle handle,char* SourceName, short BankMask, short PositionMask, short LengthMask, char * Mask, int MaskLen, short membank,int Address, int Length, void *Data, int Pwd);

/*
    CAENRFID_CustomCmd_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
        [in]  SubCmd			: The subcommand.
        [in]  RTLength			: The number of bytes to send to the tag.
        [in]  RTData			: The data to be sent to the tag.
        [in]  TRLength			: The number of bytes to be received from the tag.
        [out] TRData			: The data received from the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		Special function to implement custom commands.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use CustomCommand_EPC_C1G2 instead.")CAENRFIDErrorCodes __stdcall
CAENRFID_CustomCmd_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, unsigned char subcmd, 
						int RTLength, void *RTData, int TRLength, void *TRData);

/*
    CAENRFID_CustomCommand_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  Tag				: The tag.
        [in]  SubCmd			: The subcommand.
        [in]  RTLength			: The number of bytes to send to the tag.
        [in]  RTData			: The data to be sent to the tag.
        [in]  TRLength			: The number of bytes to be received from the tag.
        [out] TRData			: The data received from the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		Special function to implement custom commands.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_CustomCommand_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned char subcmd, 
						int RTLength, void *RTData, int TRLength, void *TRData);


/*
    CAENRFID_SecureCustomCmd_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
        [in]  SubCmd			: The subcommand.
        [in]  RTLength			: The number of bytes to send to the tag.
        [in]  RTData			: The data to be sent to the tag.
        [in]  TRLength			: The number of bytes to be received from the tag.
		[in]  Pwd				: The access Password
        [out] TRData			: The data received from the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		Special function to implement custom commands.
*/
CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.Use SecureCustomCommand_EPC_C1G2 instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_SecureCustomCmd_C1G2(CAENRFIDHandle handle, CAENRFIDTag *ID, unsigned char subcmd,
							  int RTLength, void *RTData, int TRLength, int Pwd, void *TRData);

/*
    CAENRFID_SecureCustomCommand_EPC_C1G2
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  Tag				: The tag.
        [in]  SubCmd			: The subcommand.
        [in]  RXLen  			: The number of bytes to send to the tag.
        [in]  Data				: The data to be sent to the tag.
        [in]  TXLen 			: The number of bytes to be received from the tag.
		[in]  AccessPassword	: The access Password
        [out] TRData			: The data received from the tag.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
		Special function to implement custom commands.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_SecureCustomCommand_EPC_C1G2(CAENRFIDHandle handle, CAENRFIDTag *Tag, unsigned char subcmd,
							  int RXLen, void *Data, int TXLen, int AccessPassword, void *TRData);

/* 
	CAENRFID_LockBlockPermaLock_EPC_C1G2.
	-----------------------------------------------------------------------------
	Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
        [in]  MemBank			: The memory bank where to write the data.
        [in]  BlockPtr			: The address where to start writing the data.</param>
        [in]  BlockRange		: The number of word of the mask</param>
        [in]  Mask				: A bitmask that permit to select which of the four bytes have to be locked
								 (i.e. mask 0x05 write the bytes on position Address + 1 and Address + 3)
		[in]  MaskLength		: The effective length in byte of the mask.Usually BlockRange * 2
        [in]  SecurePassword	: The access password
	-----------------------------------------------------------------------------
	Returns:
		An error code about the execution of the function.
	-----------------------------------------------------------------------------
	Description:
		This method implements the BLockPermaLock with ReadLock=1 as specified in EPCC1G2 rev. 1.2.0 protocol.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_LockBlockPermaLock_EPC_C1G2( CAENRFIDHandle handle, CAENRFIDTag *Tag, short MemBank, short BlockPtr, short BlockRange, void * Mask, int MaskLength, int AccessPassword);
/* 
	CAENRFID_LockBlockPermaLock_EPC_C1G2.
	-----------------------------------------------------------------------------
	Parameters:\
        [in]  Handle			: The handle that identifies the device.
        [in]  ID				: The tag ID.
        [in]  MemBank			: The memory bank where to read the data.
        [in]  BlockPtr			: The address where to start reading the data.</param>
        [in]  BlockRange		: The number of word to read</param>
		[out] Data				: The bytes read. The number of bytes read are BlockRange*2.
        [in]  SecurePassword	: The access password
	-----------------------------------------------------------------------------
	Returns:
		An error code about the execution of the function.
	-----------------------------------------------------------------------------
	Description:
		This method implements the BLockPermaLock with ReadLock=0 as specified in EPCC1G2 rev. 1.2.0 protocol.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ReadBlockPermaLock_EPC_C1G2( CAENRFIDHandle handle, CAENRFIDTag *Tag, short MemBank, short Blockptr, short BlockRange, void * Data, int AccessPassword);

/*
    CAENRFID_FilteredInventoryTag.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle    : The handle that identifies the device.
        [in]  LogicalSourceName : The name that identify the Logical Source
		[in]  Mask		: The array containing the ID Mask
		[in]  MaskLength : The length in bit of the significative part of the Mask
		[in]  Position	: The position in bit from where starting to compare the mask to the ID
        [out] Receive  : Returns an array containing the tags read.
        [out] Size     : Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
*/

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_FilteredInventoryTag (CAENRFIDHandle handle, char* SourceName, char* Mask, unsigned char MaskLength, unsigned char Position, CAENRFIDTag **Receive, int *Size);

/*
    CAENRFID_FlagInventoryTag.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle     : The handle that identifies the device.
        [in]  SourceName : The name that identify the Logical Source
		[in]  Mask		 : The array containing the ID Mask
		[in]  MaskLength : The length in bit of the significative part of the Mask
		[in]  Position	 : The position in bit from where starting to compare the mask to the ID
		[in]  Flag		 : A bitmask that indicates the compact mode inventory and
                           other features (see CAENRFID_InventoryFlag enum).
        [out] Receive    : Returns an array containing the tags read.
        [out] Size       : Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
		NOTE: Bit 1 and 2 of Falg parameter are ignored.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_FlagInventoryTag (CAENRFIDHandle handle, char* SourceName, char* Mask, unsigned char MaskLength, unsigned char Position,unsigned char flag,CAENRFIDTag **Receive, int *Size);


/*
    CAENRFID_FlagInventoryTagWithSubCommand.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle     : The handle that identifies the device.
        [in]  SourceName : The name that identify the Logical Source
        [in]  Mask		 : The array containing the ID Mask
        [in]  MaskLength : The length in bit of the significative part of the Mask
        [in]  Position	 : The position in bit from where starting to compare 
                           the mask to the ID
        [in]  Flag		 : A bitmask that indicates the compact mode inventory and
                           other features (see CAENRFID_InventoryFlag enum).
        [in]  subCommand : The inventory subcommand to execute.
        [out] Receive    : Returns an array containing the tags read.
        [out] Size       : Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
        NOTE: Bit 1 and 2 of Falg parameter are ignored.
        For each tag found the reader will perform a sub command.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_FlagInventoryTagWithSubCommand(CAENRFIDHandle handle, char* SourceName, char* Mask, unsigned char MaskLength,
    unsigned char Position, unsigned char flag, CAENRFID_InventorySubCommand subCommand, CAENRFIDTag** Receive, int* Size);


/*
    CAENRFID_BankFilteredFlagInventoryTag.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  LogicalSourceName : The name that identify the Logical Source
		[in]  Bank				: The bank where apply the mask
		[in]  Position			: The position in bit from where starting to compare the mask to the choosen bank
		[in]  MaskLength		: The length in bit of the significative part of the Mask
		[in]  Mask				: The array containing the ID Mask
		[in]  MaskLen			: The number of bytes passed in Mask.
		[in]  Flag				: A bitmask that indicates the compact mode inventory and
                                  other features (see CAENRFID_InventoryFlag enum).
        [out] Receive			: Returns an array containing the tags read.
        [out] Size				: Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
		It applies the mask parameters to the founded tags, retrieving only 
		tags where relative bank matches with the mask.
        In this case bit 1 and 2 of Flag (continuos and framed mode) are ignored.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BankFilteredFlagInventoryTag (CAENRFIDHandle handle, char* SourceName, short bank, short Position, short MaskLength, char * Mask, int MaskLen, unsigned char flag, CAENRFIDTag **Receive, int *Size);

/*
    CAENRFID_BankFilteredFlagInventoryTagWithSubCommand.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle			: The handle that identifies the device.
        [in]  LogicalSourceName : The name that identify the Logical Source
        [in]  Bank				: The bank where apply the mask
        [in]  Position			: The position in bit from where starting to compare the mask to the choosen bank
        [in]  MaskLength		: The length in bit of the significative part of the Mask
        [in]  Mask				: The array containing the ID Mask
        [in]  MaskLen			: The number of bytes passed in Mask.
        [in]  Flag				: A bitmask that indicates the compact mode inventory and
                                  other features (see CAENRFID_InventoryFlag enum).
        [in]  SubCommand        : The inventory subcommand to execute.
        [out] Receive			: Returns an array containing the tags read.
        [out] Size				: Returns the number of tags in the array.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function returns all the IDs of the tags under the reader field
        using all the available antennae. The Tags array contains The IDs
        together with other information related to the single ID such as the
        antenna under which is the ID and the format of the ID itself (see
        CAENRFIDTag struct for the details).
        It applies the mask parameters to the founded tags, retrieving only
        tags where relative bank matches with the mask.
        In this case bit 1 and 2 of Flag (continuos and framed mode) are ignored.
        For each tag found the reader will perform a sub command.
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_BankFilteredFlagInventoryTagWithSubCommand(CAENRFIDHandle handle, char* SourceName, short bank, short Position,
    short MaskLength, char* Mask, int MaskLen, unsigned char flag, CAENRFID_InventorySubCommand subCommand, CAENRFIDTag** Receive, int* Size);

CAENRFIDlib_API deprecate_msg("Deprecated function.Use CAENRFID_EventInventoryTag instead.") CAENRFIDErrorCodes __stdcall
CAENRFID_ExtendedInventoryTag (CAENRFIDHandle handle, CAENRFID_ExtendedInventoryParams InvParams);

/*
    CAENRFID_EventInventoryTag.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle     : The handle that identifies the device.
        [in]  SourceName : The struct representing the inventory parameters
        [in]  InvParams  : The struct that contains the filtering mask, the 
                           callback of the returned tag and the bitmask that
                           indicates the compact mode inventory and other features 
                           (see CAENRFID_InventoryFlag enum).
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function doesn't directly return anything. The tags inventoried by this
		function are passed passed to a user-definied callback passed in InvParams.pCallback
		as a CAENRFID_INVENTORY_CALLBACK (see CAENRFID_EventInventoryParams struct for details).
		The run mode of this funcitons are two:non continuos and continuos.
		In the second case (continuos mode) we can choose to pass to the callback the tag in the RF field
		all in one call (expensive in output time terms), or one per call.
		In all case we can get the tag in compact version.
		
*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_EventInventoryTag (CAENRFIDHandle handle, CAENRFID_EventInventoryParams InvParams);

/*
    CAENRFID_EventInventoryTagWithSubCommand.
    -----------------------------------------------------------------------------
    Parameters:
        [in]  Handle     : The handle that identifies the device.
        [in]  SourceName : The struct representing the inventory parameters
        [in]  InvParams  : The struct that contains the filtering mask, the 
                           callback of the returned tag and the bitmask that
                           indicates the compact mode inventory and other features 
                           (see CAENRFID_InventoryFlag enum).
        [in]  subCommand : The inventory subcommand to execute.
    -----------------------------------------------------------------------------
    Returns:
        An error code about the execution of the function.
    -----------------------------------------------------------------------------
    Description:
        The function doesn't directly return anything. The tags inventoried by this
        function are passed passed to a user-definied callback passed in InvParams.pCallback
        as a CAENRFID_INVENTORY_CALLBACK (see CAENRFID_EventInventoryParams struct for details).
        The run mode of this funcitons are two:non continuos and continuos.
        In the second case (continuos mode) we can choose to pass to the callback the tag in the RF field
        all in one call (expensive in output time terms), or one per call.
        In all case we can get the tag in compact version.
        For each tag found the reader will perform a sub command.


*/
CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_EventInventoryTagWithSubCommand(CAENRFIDHandle handle, CAENRFID_EventInventoryParams InvParams, CAENRFID_InventorySubCommand subCommand);


CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_ForceAbort(CAENRFIDHandle handle, int timeout, BOOL *endOfStreamMatched);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_InventoryAbort(CAENRFIDHandle handle);

//----------------------------Custom Command-----------------------------//

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_ReadLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, short Payload);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SecureReadLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, short Payload, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_WriteMultipleWords(CAENRFIDHandle handle, CAENRFIDTag *Tag, short membank, short address, short nbyte, char *twrite);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SecureWriteMultipleWords(CAENRFIDHandle handle, CAENRFIDTag *Tag, short membank, short address, short nbyte, char *twrite, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_BlockLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockNum, int UserPassword, char PayLoad);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SecureBlockLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockNum, int UserPassword, char PayLoad, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_BlockReadLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte BlockNum, int UserPassword, byte PayLoad);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SecureBlockReadLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, byte BlockNum, int UserPassword, byte PayLoad, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_GetSystemInformation(CAENRFIDHandle handle, CAENRFIDTag *Tag, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SecureGetSystemInformation(CAENRFIDHandle handle, CAENRFIDTag *Tag, char *TRData, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SecureSetAttenuate(CAENRFIDHandle handle, CAENRFIDTag *Tag, char Level, char LevelLock, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Hitachi_SetAttenuate(CAENRFIDHandle handle, CAENRFIDTag *Tag, char Level, char LevelLock);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_Refresh(CAENRFIDHandle handle, CAENRFIDTag *Tag, char option);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureRefresh(CAENRFIDHandle handle, CAENRFIDTag *Tag, char option, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_ChgWordLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char MemBank, short WordPtr, char Payload, int UserPassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureChgWordLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char MemBank, short WordPtr, char Payload, int UserPassword, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_ChgBlockLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockGroupPtr, int Payload, int UserPassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureChgBlockLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockGroupPtr, int Payload, int UserPassword, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_ReadBlockLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockGroupPtr, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureReadBlockLock(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockGroupPtr, char *TRData, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_ChgBlockGroupPassword(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockGroupPtr, int NewPassword, int CurrentPassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureChgBlockGroupPassword(CAENRFIDHandle handle, CAENRFIDTag *Tag, char BlockGroupPtr, int NewPassword, int CurrentPassword, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_BurstWrite(CAENRFIDHandle handle, CAENRFIDTag *Tag, char MemBank, short address, char nbyte, char *data, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureBurstWrite(CAENRFIDHandle handle, CAENRFIDTag *Tag, char MemBank, short address, char nbyte, char *data, char *TRData, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_BurstErase(CAENRFIDHandle handle, CAENRFIDTag *Tag, char MemBank, short address, char nbyte, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_Fujitsu_SecureBurstErase(CAENRFIDHandle handle, CAENRFIDTag *Tag, char MemBank, short address, char nbyte, char *TRData, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_ReadProtect(CAENRFIDHandle handle, CAENRFIDTag *Tag);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_SecureReadProtect(CAENRFIDHandle handle, CAENRFIDTag *Tag, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_ResetReadProtect(CAENRFIDHandle handle, CAENRFIDTag *Tag, int Password);

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_SecureResetReadProtect(CAENRFIDHandle handle, CAENRFIDTag *Tag, int Password, int SecurePassword);

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_ChangeEAS(CAENRFIDHandle handle, CAENRFIDTag *Tag, char EAS);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_SecureChangeEAS(CAENRFIDHandle handle, CAENRFIDTag *Tag, char EAS, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_EAS_Alarm(CAENRFIDHandle handle, char* SourceName, char *TRData);

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_SecureEAS_Alarm(CAENRFIDHandle handle, char* SourceName, char *TRData, int SecurePassword);

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_Calibrate(CAENRFIDHandle handle, CAENRFIDTag *Tag);

CAENRFIDlib_API deprecate_msg("Deprecated function.No longer support.") CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_SecureCalibrate(CAENRFIDHandle handle, CAENRFIDTag *Tag, int SecurePassword);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_ChangeConfig(CAENRFIDHandle handle, CAENRFIDTag *Tag, short ConfigWord, char *TRData);

CAENRFIDlib_API CAENRFIDErrorCodes __stdcall
CAENRFID_NXP_SecureChangeConfig(CAENRFIDHandle handle, CAENRFIDTag *Tag, short ConfigWord, char *TRData, int SecurePassword);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __CAENRFIDLIB_H
